/*
 * Decompiled with CFR 0.152.
 */
package com.youzu.bcore.module.tools;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;

public class ToolsDialog
extends LinearLayout {
    private Context mContext;
    private int mLayoutWidth;
    private OnButtonClickListener mListener;
    private WindowManager.LayoutParams mWinParams;
    private WindowManager mWinManager;

    public ToolsDialog(Context context) {
        super(context);
        this.mContext = context;
        this.mLayoutWidth = this.getLayoutWidth(context);
        this.onInitWindow(context);
        this.onInit(context);
    }

    private void onInitWindow(Context context) {
        this.mWinManager = (WindowManager)context.getSystemService("window");
        this.mWinParams = new WindowManager.LayoutParams();
        this.mWinParams.width = -2;
        this.mWinParams.height = -2;
        this.mWinParams.type = 2;
        this.mWinParams.format = -3;
        this.mWinParams.gravity = 17;
    }

    private void onInit(Context context) {
        this.setOrientation(1);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.mLayoutWidth * 400 / 600, -2);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        GradientDrawable draw = new GradientDrawable();
        draw.setColor(-1);
        draw.setCornerRadius((float)(this.mLayoutWidth * 8 / 600));
        this.setBackgroundColor(-1);
    }

    public void setTitle(String title) {
        TextView view = new TextView(this.mContext);
        view.setText((CharSequence)title);
        view.setTextSize(0, (float)(this.mLayoutWidth * 38 / 600));
        view.setGravity(17);
        view.setTextColor(-16777216);
        int padding = this.mLayoutWidth * 40 / 600;
        view.setPadding(padding, padding / 2, padding, 0);
        this.addView((View)view);
    }

    public void setContent(String content) {
        TextView view = new TextView(this.mContext);
        view.setText((CharSequence)content);
        view.setTextSize(0, (float)(this.mLayoutWidth * 36 / 600));
        view.setGravity(17);
        view.setTextColor(-12303292);
        int padding = this.mLayoutWidth * 40 / 600;
        view.setPadding(padding, 0, padding, padding / 2);
        this.addView((View)view);
    }

    @SuppressLint(value={"NewApi"})
    public void setButtonEvent(OnButtonClickListener listener, String ... button) {
        this.mListener = listener;
        LinearLayout layout = new LinearLayout(this.mContext);
        layout.setOrientation(0);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        for (String str : button) {
            final Button btn = new Button(this.mContext);
            LinearLayout.LayoutParams btnParams = new LinearLayout.LayoutParams(-2, -2, 1.0f);
            int mar = -this.mLayoutWidth * 8 / 600;
            btnParams.setMargins(mar, mar, mar, mar + mar / 2);
            btn.setText((CharSequence)str);
            btn.setTextSize(0, (float)(this.mLayoutWidth * 34 / 600));
            btn.setGravity(17);
            btn.setLayoutParams((ViewGroup.LayoutParams)btnParams);
            btn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ToolsDialog.this.dimiss();
                    if (ToolsDialog.this.mListener != null) {
                        ToolsDialog.this.mListener.onClick(btn);
                    }
                }
            });
            layout.addView((View)btn);
        }
        this.addView((View)layout, (ViewGroup.LayoutParams)params);
    }

    public void show() {
        this.mWinManager.addView((View)this, (ViewGroup.LayoutParams)this.mWinParams);
    }

    public void hide() {
        this.setVisibility(8);
    }

    public void dimiss() {
        this.mWinManager.removeViewImmediate((View)this);
    }

    private int getLayoutWidth(Context context) {
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        int width = dm.widthPixels;
        int heigth = dm.heightPixels;
        return Math.min(width, heigth) * 5 / 6;
    }

    public static interface OnButtonClickListener {
        public void onClick(Button var1);
    }
}

