/*
 * Decompiled with CFR 0.152.
 */
package com.youzu.bcore.module.tools;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.play.core.review.ReviewInfo;
import com.google.android.play.core.review.ReviewManager;
import com.google.android.play.core.review.ReviewManagerFactory;
import com.youzu.android.framework.HttpUtils;
import com.youzu.android.framework.JsonUtils;
import com.youzu.android.framework.exception.HttpException;
import com.youzu.android.framework.http.RequestParams;
import com.youzu.android.framework.http.callback.RequestCallBack;
import com.youzu.android.framework.http.client.HttpRequest;
import com.youzu.bcore.base.BCoreCode;
import com.youzu.bcore.base.BCoreLog;
import com.youzu.bcore.base.BCoreModuleManager;
import com.youzu.bcore.base.BCoreUrls;
import com.youzu.bcore.base.BaseUrls;
import com.youzu.bcore.module.config.ConfigHandler;
import com.youzu.bcore.module.tools.ToolsDialog;
import com.youzu.bcore.module.tools.ToolsModule;
import com.youzu.bcore.module.tools.utils.ToolsUtils;
import com.youzu.bcore.utils.AppUtils;
import com.youzu.bcore.utils.DeviceUtil;
import com.youzu.bcore.utils.EncryptUtils;
import com.youzu.bcore.utils.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.json.JSONException;
import org.json.JSONObject;

public class ToolsHandler {
    private static String mPackageName;
    private static String mYouzuId;
    private static String mShuMeiId;
    private static String mAfId;
    private static String mYzAdId;
    private static String mGoogleId;
    private static String mFingerprintId;
    private static String mChannelId;
    private static JSONObject mToolsSDKObject;

    private ToolsHandler() {
        mToolsSDKObject = BaseUrls.getInstance().getUrlConfig((Context)BCoreModuleManager.getInstance().getActivity(), "Tools");
    }

    public static final ToolsHandler getInstance() {
        return InstanceImpl.mInstance;
    }

    public void getDeviceCheckInfo(Map<String, Object> map) {
        if (!BCoreUrls.getInstance().isForeign()) {
            com.youzu.android.framework.json.JSONObject json = new com.youzu.android.framework.json.JSONObject();
            json.put("code", (Object)-1);
            json.put("msg", (Object)"\u5f53\u524d\u975e\u6d77\u5916\u6e38\u620f\uff0c\u8bf7\u8054\u7cfb@SDK\u5904\u7406\uff0c\u6216\u786e\u8ba4\u56fd\u5185\u6e38\u620f\u662f\u5426\u9700\u8981\u63a5\u5165\u3002");
            ToolsModule.getInstance().getModuleListener().onModule("tools", "getDeviceCheckInfo", json.toJSONString());
            return;
        }
        if (mToolsSDKObject == null) {
            com.youzu.android.framework.json.JSONObject json = new com.youzu.android.framework.json.JSONObject();
            json.put("code", (Object)-1);
            json.put("msg", (Object)"config\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            ToolsModule.getInstance().getModuleListener().onModule("tools", "getDeviceCheckInfo", json.toJSONString());
            return;
        }
        String urlStringBase64 = null;
        try {
            urlStringBase64 = mToolsSDKObject.getString("deviceCheck");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (urlStringBase64 == null) {
            com.youzu.android.framework.json.JSONObject json = new com.youzu.android.framework.json.JSONObject();
            json.put("code", (Object)-1);
            json.put("msg", (Object)"config\u6587\u4ef6\u4e2d\uff0cdeviceCheck\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            ToolsModule.getInstance().getModuleListener().onModule("tools", "getDeviceCheckInfo", json.toJSONString());
            return;
        }
        String domain = EncryptUtils.deBase64fromString((String)urlStringBase64);
        String url = "https://" + domain + "/api/device_check";
        String gameId = ConfigHandler.getInstance().getGameId();
        String ts = String.valueOf(System.currentTimeMillis());
        RequestParams params = new RequestParams();
        params.addBodyParameter("game_id", gameId);
        params.addBodyParameter("gaid", this.getGoogleId());
        params.addBodyParameter("idfa", "");
        params.addBodyParameter("yzid", this.getYouzuId(null));
        params.addBodyParameter("ts", ts);
        String signKey = "eec67267-7dad-48f1-a9a0-6a3ccc420cda";
        String sign = EncryptUtils.MD5((String)(signKey + ts));
        params.addBodyParameter("sign", sign);
        Log.d((String)"getDeviceCheckInfo", (String)("getDeviceCheckInfo:params: " + params.toString()));
        new HttpUtils().send(HttpRequest.HttpMethod.POST, url, params, (RequestCallBack)new RequestCallBack<String>(){

            public void onSuccess(String response) {
                Log.d((String)"getDeviceCheckInfo", (String)("getDeviceCheckInfo:onSuccess: " + response));
                int status = -1;
                String msg = "\u8bbf\u95ee\u670d\u52a1\u5668\u5931\u8d25\uff0cjson\u89e3\u6790\u51fa\u9519: " + response;
                String data = "";
                try {
                    com.youzu.android.framework.json.JSONObject resp = JsonUtils.parseObject((String)response);
                    status = resp.getIntValue("status");
                    msg = resp.getString("message");
                    data = resp.getString("data");
                }
                catch (com.youzu.android.framework.json.JSONException e) {
                    e.printStackTrace();
                }
                com.youzu.android.framework.json.JSONObject json = new com.youzu.android.framework.json.JSONObject();
                if (status == 0) {
                    json.put("code", (Object)1);
                    json.put("msg", (Object)"success");
                    json.put("data", (Object)data);
                } else {
                    json.put("code", (Object)status);
                    json.put("msg", (Object)msg);
                }
                ToolsModule.getInstance().getModuleListener().onModule("tools", "getDeviceCheckInfo", json.toJSONString());
            }

            public void onFailure(HttpException error, String msg) {
                Log.d((String)"getDeviceCheckInfo", (String)("getDeviceCheckInfo:onFailure: " + msg));
                com.youzu.android.framework.json.JSONObject json = new com.youzu.android.framework.json.JSONObject();
                json.put("code", (Object)-1);
                json.put("msg", (Object)error.toString());
                ToolsModule.getInstance().getModuleListener().onModule("tools", "getDeviceCheckInfo", json.toJSONString());
            }
        });
    }

    public void getClientIPInfo(Map<String, Object> map) {
        BCoreLog.d((String)"getClientIPInfo");
        String deviceId = DeviceUtil.getDeviceId((Context)ToolsModule.getInstance().getActivity());
        String configId = ConfigHandler.getInstance().getConfigInfo("osdk_conf_id", "");
        String key = ConfigHandler.getInstance().getConfigInfo("solution_key", "");
        if (mToolsSDKObject == null) {
            com.youzu.android.framework.json.JSONObject json = new com.youzu.android.framework.json.JSONObject();
            json.put("code", (Object)-1);
            json.put("msg", (Object)"config\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            ToolsModule.getInstance().getModuleListener().onModule("tools", "getClientIPInfo", json.toJSONString());
            return;
        }
        String clientIpForeign = null;
        String clientIpChina = null;
        try {
            clientIpForeign = mToolsSDKObject.getString("clientIpForeign");
            clientIpChina = mToolsSDKObject.getString("clientIpChina");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (clientIpForeign == null || clientIpChina == null) {
            com.youzu.android.framework.json.JSONObject json = new com.youzu.android.framework.json.JSONObject();
            json.put("code", (Object)-1);
            json.put("msg", (Object)"config\u6587\u4ef6\u4e2d\uff0c\u53c2\u6570\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            ToolsModule.getInstance().getModuleListener().onModule("tools", "getClientIPInfo", json.toJSONString());
            return;
        }
        String domain = BCoreUrls.getInstance().isForeign() ? EncryptUtils.deBase64fromString((String)clientIpForeign) : EncryptUtils.deBase64fromString((String)clientIpChina);
        String url = "https://" + domain + "/Api/Api/GetClientIpInfo";
        String sign = EncryptUtils.MD5((String)(configId + deviceId + key));
        RequestParams params = new RequestParams();
        params.addBodyParameter("device_id", deviceId);
        params.addBodyParameter("config_id", configId);
        params.addBodyParameter("sign", sign);
        params.addBodyParameter("version", "2.0");
        BCoreLog.v((String)("url=" + url + params));
        new HttpUtils().send(HttpRequest.HttpMethod.POST, url, params, (RequestCallBack)new RequestCallBack<String>(){

            public void onSuccess(String response) {
                BCoreLog.d((String)response);
                int status = -1;
                String msg = "\u8bbf\u95ee\u670d\u52a1\u5668\u5931\u8d25\uff0cjson\u89e3\u6790\u51fa\u9519: " + response;
                String data = "";
                try {
                    com.youzu.android.framework.json.JSONObject resp = JsonUtils.parseObject((String)response);
                    status = resp.getIntValue("status");
                    msg = resp.getString("msg");
                    data = resp.getString("data");
                }
                catch (com.youzu.android.framework.json.JSONException e) {
                    e.printStackTrace();
                }
                com.youzu.android.framework.json.JSONObject json = new com.youzu.android.framework.json.JSONObject();
                if (status == 1) {
                    json.put("code", (Object)1);
                    json.put("msg", (Object)"success");
                    json.put("data", (Object)JsonUtils.parseObject((String)data));
                } else {
                    json.put("code", (Object)status);
                    json.put("msg", (Object)msg);
                }
                ToolsModule.getInstance().getModuleListener().onModule("tools", "getClientIPInfo", json.toJSONString());
            }

            public void onFailure(HttpException error, String msg) {
                super.onFailure(error, msg);
                BCoreLog.w((String)("getClientIPInfo failed: " + msg));
                BCoreLog.v((String)Log.getStackTraceString((Throwable)error));
                com.youzu.android.framework.json.JSONObject json = new com.youzu.android.framework.json.JSONObject();
                json.put("code", (Object)BCoreCode.TOOLS_IPINFO_FAILURE);
                json.put("msg", (Object)error.toString());
                ToolsModule.getInstance().getModuleListener().onModule("tools", "getClientIPInfo", json.toJSONString());
            }
        });
    }

    public void getClientIP(Map<String, Object> map) {
        BCoreLog.d((String)"getClientIP");
        String deviceId = DeviceUtil.getDeviceId((Context)ToolsModule.getInstance().getActivity());
        String configId = ConfigHandler.getInstance().getConfigInfo("osdk_conf_id", "");
        String key = ConfigHandler.getInstance().getConfigInfo("solution_key", "");
        if (mToolsSDKObject == null) {
            com.youzu.android.framework.json.JSONObject json = new com.youzu.android.framework.json.JSONObject();
            json.put("code", (Object)-1);
            json.put("msg", (Object)"config\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            ToolsModule.getInstance().getModuleListener().onModule("tools", "getClientIPInfo", json.toJSONString());
            return;
        }
        String clientIpForeign = null;
        String clientIpChina = null;
        try {
            clientIpForeign = mToolsSDKObject.getString("clientIpForeign");
            clientIpChina = mToolsSDKObject.getString("clientIpChina");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (clientIpForeign == null || clientIpChina == null) {
            com.youzu.android.framework.json.JSONObject json = new com.youzu.android.framework.json.JSONObject();
            json.put("code", (Object)-1);
            json.put("msg", (Object)"config\u6587\u4ef6\u4e2d\uff0c\u53c2\u6570\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            ToolsModule.getInstance().getModuleListener().onModule("tools", "getClientIPInfo", json.toJSONString());
            return;
        }
        String domain = BCoreUrls.getInstance().isForeign() ? EncryptUtils.deBase64fromString((String)clientIpForeign) : EncryptUtils.deBase64fromString((String)clientIpChina);
        String url = "https://" + domain + "/Api/Api/GetClientIpInfo";
        String sign = EncryptUtils.MD5((String)(configId + deviceId + key));
        RequestParams params = new RequestParams();
        params.addBodyParameter("device_id", deviceId);
        params.addBodyParameter("config_id", configId);
        params.addBodyParameter("sign", sign);
        params.addBodyParameter("version", "2.0");
        BCoreLog.v((String)("url=" + url + params));
        new HttpUtils().send(HttpRequest.HttpMethod.POST, url, params, (RequestCallBack)new RequestCallBack<String>(){

            public void onSuccess(String response) {
                BCoreLog.d((String)response);
                int status = -1;
                String msg = "\u8bbf\u95ee\u670d\u52a1\u5668\u5931\u8d25\uff0cjson\u89e3\u6790\u51fa\u9519: " + response;
                String data = "";
                try {
                    com.youzu.android.framework.json.JSONObject resp = JsonUtils.parseObject((String)response);
                    status = resp.getIntValue("status");
                    msg = resp.getString("msg");
                    data = resp.getString("data");
                }
                catch (com.youzu.android.framework.json.JSONException e) {
                    e.printStackTrace();
                }
                com.youzu.android.framework.json.JSONObject json = new com.youzu.android.framework.json.JSONObject();
                if (status == 1) {
                    json.put("code", (Object)1);
                    json.put("msg", (Object)"success");
                    json.put("data", (Object)JsonUtils.parseObject((String)data));
                } else {
                    json.put("code", (Object)status);
                    json.put("msg", (Object)msg);
                }
                ToolsModule.getInstance().getModuleListener().onModule("tools", "getClientIP", json.toJSONString());
            }

            public void onFailure(HttpException error, String msg) {
                super.onFailure(error, msg);
                BCoreLog.w((String)("getClientIPInfoJson failed: " + msg));
                BCoreLog.v((String)Log.getStackTraceString((Throwable)error));
                com.youzu.android.framework.json.JSONObject json = new com.youzu.android.framework.json.JSONObject();
                json.put("code", (Object)BCoreCode.TOOLS_IPINFO_FAILURE);
                json.put("msg", (Object)error.toString());
                ToolsModule.getInstance().getModuleListener().onModule("tools", "getClientIP", json.toJSONString());
            }
        });
    }

    public void getClientIPInfoJson(Map<String, Object> map) {
        BCoreLog.d((String)"getClientIPInfoJson");
        String deviceId = DeviceUtil.getDeviceId((Context)ToolsModule.getInstance().getActivity());
        String configId = ConfigHandler.getInstance().getConfigInfo("osdk_conf_id", "");
        String key = ConfigHandler.getInstance().getConfigInfo("solution_key", "");
        if (mToolsSDKObject == null) {
            com.youzu.android.framework.json.JSONObject json = new com.youzu.android.framework.json.JSONObject();
            json.put("code", (Object)-1);
            json.put("msg", (Object)"config\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            ToolsModule.getInstance().getModuleListener().onModule("tools", "getClientIPInfo", json.toJSONString());
            return;
        }
        String clientIpForeign = null;
        String clientIpChina = null;
        try {
            clientIpForeign = mToolsSDKObject.getString("clientIpForeign");
            clientIpChina = mToolsSDKObject.getString("clientIpChina");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (clientIpForeign == null || clientIpChina == null) {
            com.youzu.android.framework.json.JSONObject json = new com.youzu.android.framework.json.JSONObject();
            json.put("code", (Object)-1);
            json.put("msg", (Object)"config\u6587\u4ef6\u4e2d\uff0c\u53c2\u6570\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            ToolsModule.getInstance().getModuleListener().onModule("tools", "getClientIPInfo", json.toJSONString());
            return;
        }
        String domain = BCoreUrls.getInstance().isForeign() ? EncryptUtils.deBase64fromString((String)clientIpForeign) : EncryptUtils.deBase64fromString((String)clientIpChina);
        String url = "https://" + domain + "/Api/Api/GetClientIpInfo";
        String sign = EncryptUtils.MD5((String)(configId + deviceId + key));
        RequestParams params = new RequestParams();
        params.addBodyParameter("device_id", deviceId);
        params.addBodyParameter("config_id", configId);
        params.addBodyParameter("sign", sign);
        params.addBodyParameter("version", "2.0");
        BCoreLog.v((String)("url=" + url + params));
        new HttpUtils().send(HttpRequest.HttpMethod.POST, url, params, (RequestCallBack)new RequestCallBack<String>(){

            public void onSuccess(String response) {
                BCoreLog.d((String)response);
                int status = -1;
                String msg = "\u8bbf\u95ee\u670d\u52a1\u5668\u5931\u8d25\uff0cjson\u89e3\u6790\u51fa\u9519: " + response;
                String data = "";
                try {
                    com.youzu.android.framework.json.JSONObject resp = JsonUtils.parseObject((String)response);
                    status = resp.getIntValue("status");
                    msg = resp.getString("msg");
                    data = resp.getString("data");
                }
                catch (com.youzu.android.framework.json.JSONException e) {
                    e.printStackTrace();
                }
                com.youzu.android.framework.json.JSONObject json = new com.youzu.android.framework.json.JSONObject();
                if (status == 1) {
                    json.put("code", (Object)1);
                    json.put("msg", (Object)"success");
                    json.put("data", (Object)JsonUtils.parseObject((String)data));
                } else {
                    json.put("code", (Object)status);
                    json.put("msg", (Object)msg);
                }
                ToolsModule.getInstance().getModuleListener().onModule("tools", "getClientIPInfoJson", json.toJSONString());
            }

            public void onFailure(HttpException error, String msg) {
                super.onFailure(error, msg);
                BCoreLog.w((String)("getClientIPInfoJson failed: " + msg));
                BCoreLog.v((String)Log.getStackTraceString((Throwable)error));
                com.youzu.android.framework.json.JSONObject json = new com.youzu.android.framework.json.JSONObject();
                json.put("code", (Object)BCoreCode.TOOLS_IPINFO_FAILURE);
                json.put("msg", (Object)error.toString());
                ToolsModule.getInstance().getModuleListener().onModule("tools", "getClientIPInfoJson", json.toJSONString());
            }
        });
    }

    public String getDeviceId(Map<String, Object> params) {
        BCoreLog.d((String)"getDeviceId");
        return DeviceUtil.getDeviceId((Context)ToolsModule.getInstance().getActivity());
    }

    public String getNewDeviceId(Map<String, Object> params) {
        BCoreLog.d((String)"getNewDeviceId");
        return DeviceUtil.getNewDeviceID((Context)ToolsModule.getInstance().getActivity());
    }

    public String getIMSIValue(Map<String, Object> params) {
        BCoreLog.d((String)"getIMSIValue");
        return DeviceUtil.getIMSIValue((Context)ToolsModule.getInstance().getActivity());
    }

    public String getPackageName(Map<String, Object> params) {
        BCoreLog.d((String)"getPackageName");
        if (TextUtils.isEmpty((CharSequence)mPackageName)) {
            mPackageName = ToolsModule.getInstance().getActivity().getPackageName();
        }
        return mPackageName;
    }

    public String getYouzuId(Map<String, Object> params) {
        if (TextUtils.isEmpty((CharSequence)mYouzuId)) {
            SharedPreferences sharedPreferences = ToolsModule.getInstance().getActivity().getSharedPreferences("yzid_sp_name", 0);
            mYouzuId = sharedPreferences.getString("youzu_id", "0");
        }
        return mYouzuId;
    }

    public String getShuMeiId(Map<String, Object> params) {
        if (TextUtils.isEmpty((CharSequence)mShuMeiId)) {
            SharedPreferences sharedPreferences = ToolsModule.getInstance().getActivity().getSharedPreferences("youzu_device_id_sp_name", 0);
            mShuMeiId = sharedPreferences.getString("shumei_id", "");
        }
        return mShuMeiId;
    }

    public String getAfId(Map<String, Object> params) {
        if (TextUtils.isEmpty((CharSequence)mAfId)) {
            SharedPreferences sharedPreferences = ToolsModule.getInstance().getActivity().getSharedPreferences("youzu_device_id_sp_name", 0);
            mAfId = sharedPreferences.getString("appsflyer_id", "");
        }
        return mAfId;
    }

    public String getYzadid(Map<String, Object> params) {
        if (TextUtils.isEmpty((CharSequence)mYzAdId)) {
            SharedPreferences sharedPreferences = ToolsModule.getInstance().getActivity().getSharedPreferences("analysis_sp_name", 0);
            mYzAdId = BCoreUrls.getInstance().isForeign() ? sharedPreferences.getString("google_ad_id", "0") : sharedPreferences.getString("oaid", "0");
        }
        return mYzAdId;
    }

    public String getLanguage(Map<String, Object> params) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (!TextUtils.isEmpty((CharSequence)Locale.getDefault().getDisplayName()) && Locale.getDefault().getDisplayName().contains("\u4e2d\u6587")) {
                return ToolsUtils.toLanguageTag(Locale.getDefault().toLanguageTag());
            }
            BCoreLog.d((String)("\u65e0\u4e2d\u6587\u8fd4\u56de = " + Locale.getDefault().getLanguage().toLowerCase() + "-" + Locale.getDefault().getCountry().toUpperCase()));
            return Locale.getDefault().getLanguage().toLowerCase() + "-" + Locale.getDefault().getCountry().toUpperCase();
        }
        String mLanguage = Locale.getDefault().getLanguage();
        String mChinese = "";
        if (!TextUtils.isEmpty((CharSequence)Locale.getDefault().getDisplayName()) && Locale.getDefault().getDisplayName().contains("\u4e2d\u6587")) {
            mChinese = Locale.getDefault().getDisplayName().contains("\u4e2d\u56fd") ? "-Hans" : "-Hant";
        }
        if (!TextUtils.isEmpty((CharSequence)Locale.getDefault().getDisplayName()) && Locale.getDefault().getDisplayName().contains("\u7b80\u4f53\u4e2d\u6587")) {
            mChinese = "-Hans";
        }
        if (!TextUtils.isEmpty((CharSequence)Locale.getDefault().getDisplayName()) && Locale.getDefault().getDisplayName().contains("\u7e41\u9ad4\u4e2d\u6587")) {
            mChinese = "-Hant";
        }
        mLanguage = !TextUtils.isEmpty((CharSequence)mChinese) ? mLanguage + mChinese + "-" + Locale.getDefault().getCountry().toUpperCase() : mLanguage + "-" + Locale.getDefault().getCountry().toUpperCase();
        BCoreLog.d((String)("5.0\u4ee5\u4e0b\u8fd4\u56de = " + mLanguage));
        return mLanguage;
    }

    public String getDeviceInfo(Map<String, Object> params) {
        Activity context = ToolsModule.getInstance().getActivity();
        com.youzu.android.framework.json.JSONObject jsonObject = new com.youzu.android.framework.json.JSONObject();
        try {
            jsonObject.put("android_id", (Object)DeviceUtil.getDeviceId((Context)context));
            jsonObject.put("android_device_id", (Object)DeviceUtil.getDeviceId((Context)context));
            jsonObject.put("imei", (Object)DeviceUtil.getDeviceId((Context)context));
            jsonObject.put("android_imei", (Object)DeviceUtil.getDeviceId((Context)context));
            jsonObject.put("google_id", (Object)this.getGoogleId());
            jsonObject.put("youzu_id", (Object)this.getYouzuId(params));
            jsonObject.put("shumei_id", (Object)this.getShuMeiId(params));
            jsonObject.put("three_stage_id", (Object)DeviceUtil.getDeviceId((Context)context));
            jsonObject.put("appsflyer_id", (Object)this.getAfId(params));
            SharedPreferences sharedPreferences = context.getSharedPreferences("youzu_device_id_sp_name", 0);
            jsonObject.put("trace_id", (Object)sharedPreferences.getString("trace_id", ""));
            String deviceName = this.getDeviceName(params);
            if (deviceName.contains("|")) {
                deviceName.replace("|", "#");
            }
            jsonObject.put("device_name", (Object)deviceName);
            jsonObject.put("package_name", (Object)this.getPackageName(params));
            jsonObject.put("client_id", (Object)this.getYouzuId(params));
            jsonObject.put("fingerprint_id", (Object)this.getFingerprintId());
            jsonObject.put("udid", (Object)"");
            jsonObject.put("idfa", (Object)"");
            jsonObject.put("idfv", (Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject.toString();
    }

    private String getGoogleId() {
        Activity context = ToolsModule.getInstance().getActivity();
        if (context == null) {
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)mGoogleId)) {
            SharedPreferences sharedPreferences = context.getSharedPreferences("analysis_sp_name", 0);
            mGoogleId = sharedPreferences.getString("google_ad_id", "");
        }
        return mGoogleId;
    }

    public String getFingerprintId() {
        Activity context = ToolsModule.getInstance().getActivity();
        if (context == null) {
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)mFingerprintId)) {
            SharedPreferences sharedPreferences = context.getSharedPreferences("collect_sp_name", 0);
            mFingerprintId = sharedPreferences.getString("fingerprint_id", "");
        }
        return mFingerprintId;
    }

    public String getDeviceName(Map<String, Object> params) {
        return "";
    }

    public String getSingleLanguage(Map<String, Object> params) {
        String mLanguage = Locale.getDefault().getLanguage();
        BCoreLog.d((String)("getSingleLanguage \uff1a" + mLanguage));
        return mLanguage;
    }

    public String getCountry(Map<String, Object> params) {
        String country = Locale.getDefault().getCountry();
        BCoreLog.d((String)("getCountry\uff1a" + country));
        return country;
    }

    public String getCollectionData(Map<String, Object> params) {
        String collectingData = AppUtils.getCollectingData();
        BCoreLog.d((String)("getCollectionData\uff1a" + collectingData));
        return collectingData;
    }

    public boolean copyToClipboard(final Map<String, Object> params) {
        BCoreLog.d((String)"copyToClipboard");
        if (params == null || params.get("value") == null) {
            BCoreLog.w((String)"copyToClipboard BCoreConst.tools.KEY_VALUE is empty, please setting this value");
            return false;
        }
        ToolsModule.getInstance().getActivity().runOnUiThread(new Runnable(){

            @Override
            @SuppressLint(value={"NewApi"})
            public void run() {
                ClipboardManager clip = (ClipboardManager)ToolsModule.getInstance().getActivity().getSystemService("clipboard");
                clip.setPrimaryClip(ClipData.newPlainText(null, (CharSequence)params.get("value").toString()));
            }
        });
        return true;
    }

    public boolean alert(Map<String, Object> params) {
        BCoreLog.d((String)"alert");
        if (params == null) {
            BCoreLog.w((String)"alert params map is null, failed, please setting this value");
            return false;
        }
        final String title = StringUtil.toString((Object)params.get("tools_title"));
        final String content = StringUtil.toString((Object)params.get("tools_content"));
        String buttons = StringUtil.toString((Object)params.get("tools_button"));
        if (TextUtils.isEmpty((CharSequence)buttons)) {
            if (TextUtils.isEmpty((CharSequence)title) && TextUtils.isEmpty((CharSequence)content)) {
                BCoreLog.w((String)"alert BCoreConst.tools.KEY_TOOLS_CONTENT is empty, failed, please setting this value");
                return false;
            }
            ToolsModule.getInstance().getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (!TextUtils.isEmpty((CharSequence)title) && !TextUtils.isEmpty((CharSequence)content)) {
                        Toast.makeText((Context)ToolsModule.getInstance().getActivity(), (CharSequence)(title + ": " + content), (int)0).show();
                        return;
                    }
                    if (!TextUtils.isEmpty((CharSequence)title)) {
                        Toast.makeText((Context)ToolsModule.getInstance().getActivity(), (CharSequence)title, (int)0).show();
                        return;
                    }
                    if (!TextUtils.isEmpty((CharSequence)content)) {
                        Toast.makeText((Context)ToolsModule.getInstance().getActivity(), (CharSequence)content, (int)0).show();
                    }
                }
            });
            return true;
        }
        String[] btns = buttons.split("\\|");
        final ToolsDialog dialog = new ToolsDialog((Context)ToolsModule.getInstance().getActivity());
        if (!TextUtils.isEmpty((CharSequence)title)) {
            dialog.setTitle(title);
        }
        if (!TextUtils.isEmpty((CharSequence)content)) {
            dialog.setContent(content);
        }
        dialog.setButtonEvent(new ToolsDialog.OnButtonClickListener(){

            @Override
            public void onClick(Button view) {
                if (ToolsModule.getInstance().getModuleListener() != null) {
                    com.youzu.android.framework.json.JSONObject json = new com.youzu.android.framework.json.JSONObject();
                    json.put("code", (Object)1);
                    json.put("msg", (Object)"success");
                    json.put("data", (Object)view.getText().toString());
                    ToolsModule.getInstance().getModuleListener().onModule("tools", "alert", json.toJSONString());
                }
            }
        }, btns);
        ToolsModule.getInstance().getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                dialog.show();
            }
        });
        return true;
    }

    public String getVersionName(Map<String, Object> params) {
        BCoreLog.d((String)"getVersionName");
        try {
            return ToolsModule.getInstance().getActivity().getPackageManager().getPackageInfo((String)ToolsModule.getInstance().getActivity().getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getVersionCode(Map<String, Object> params) {
        BCoreLog.d((String)"getVersionCode");
        try {
            return ToolsModule.getInstance().getActivity().getPackageManager().getPackageInfo((String)ToolsModule.getInstance().getActivity().getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public String getAppName(Map<String, Object> params) {
        BCoreLog.d((String)"getAppName");
        try {
            Activity activity = ToolsModule.getInstance().getActivity();
            return activity.getPackageManager().getPackageInfo((String)activity.getPackageName(), (int)0).applicationInfo.loadLabel(activity.getPackageManager()).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getMetaData(Map<String, Object> params) {
        BCoreLog.d((String)"getMetaData");
        if (params == null || params.get("key") == null) {
            BCoreLog.w((String)"getMetaData BCoreConst.tools.KEY is empty, failed, please setting this value");
            return null;
        }
        try {
            ApplicationInfo info = ToolsModule.getInstance().getActivity().getPackageManager().getApplicationInfo(ToolsModule.getInstance().getActivity().getPackageName(), 128);
            if (info != null && info.metaData != null) {
                return StringUtil.toString((Object)info.metaData.get(params.get("key").toString()));
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            BCoreLog.w((String)"meta-data no this key");
        }
        return null;
    }

    public boolean setScreenLight(Map<String, Object> params) {
        BCoreLog.d((String)"setScreenLight");
        if (params == null || params.get("value") == null) {
            BCoreLog.w((String)"getMetaData BCoreConst.tools.KEY_VALUE is empty, failed, please setting this value");
            return false;
        }
        ContentResolver resolver = ToolsModule.getInstance().getActivity().getContentResolver();
        try {
            if (Settings.System.getInt((ContentResolver)resolver, (String)"screen_brightness_mode") == 1) {
                Settings.System.putInt((ContentResolver)resolver, (String)"screen_brightness_mode", (int)0);
            }
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
        }
        float light = 0.0f;
        try {
            light = Float.parseFloat(params.get("value").toString());
            if (light > 1.0f) {
                light = 1.0f;
            }
            if (light < 0.0f) {
                light = 0.0f;
            }
            WindowManager.LayoutParams att = ToolsModule.getInstance().getActivity().getWindow().getAttributes();
            att.screenBrightness = light;
            Uri uri = Settings.System.getUriFor((String)"screen_brightness");
            Settings.System.putInt((ContentResolver)resolver, (String)"screen_brightness", (int)((int)(light * 255.0f)));
            resolver.notifyChange(uri, null);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean saveData(Map<String, Object> params) {
        BCoreLog.d((String)"saveData");
        if (params == null || params.get("key") == null || params.get("value") == null) {
            BCoreLog.w((String)"saveData failed: KEY and KEY_VALUE is empty");
            return false;
        }
        File cacheDir = new File(ToolsModule.getInstance().getActivity().getCacheDir(), "bcore");
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            BCoreLog.w((String)"saveData failed: mkdirs failed");
            return false;
        }
        File cacheFile = new File(cacheDir, "data.cache");
        BCoreLog.d((String)("saveData: target file = " + cacheFile.getAbsolutePath()));
        try {
            if (!cacheFile.exists() && !cacheFile.createNewFile()) {
                BCoreLog.w((String)"saveData failed: create file failed");
                return false;
            }
            StringBuilder sb = new StringBuilder();
            try (FileInputStream fis = new FileInputStream(cacheFile);){
                int len;
                byte[] buffer = new byte[1024];
                while ((len = fis.read(buffer)) != -1) {
                    sb.append(new String(buffer, 0, len));
                }
            }
            com.youzu.android.framework.json.JSONObject json = TextUtils.isEmpty((CharSequence)sb.toString()) ? new com.youzu.android.framework.json.JSONObject() : JsonUtils.parseObject((String)sb.toString());
            String key = params.get("key").toString();
            String value = params.get("value").toString();
            json.put(key, (Object)value);
            try (FileOutputStream fos = new FileOutputStream(cacheFile);){
                fos.write(json.toJSONString().getBytes());
                fos.flush();
            }
            return true;
        }
        catch (IOException e) {
            BCoreLog.e((String)("saveData exception: " + e.getMessage()));
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getData(Map<String, Object> params) {
        BCoreLog.d((String)"getData");
        if (params == null || params.get("key") == null) {
            BCoreLog.w((String)"getData failed: KEY is null");
            return null;
        }
        File cacheDir = new File(ToolsModule.getInstance().getActivity().getCacheDir(), "bcore");
        File cacheFile = new File(cacheDir, "data.cache");
        if (!cacheFile.exists()) {
            BCoreLog.w((String)"getData failed: cache file not found");
            return null;
        }
        String key = params.get("key").toString();
        try (FileInputStream fis = new FileInputStream(cacheFile);){
            int len;
            StringBuilder sb = new StringBuilder();
            byte[] buffer = new byte[1024];
            while ((len = fis.read(buffer)) != -1) {
                sb.append(new String(buffer, 0, len));
            }
            com.youzu.android.framework.json.JSONObject json = TextUtils.isEmpty((CharSequence)sb.toString()) ? new com.youzu.android.framework.json.JSONObject() : JsonUtils.parseObject((String)sb.toString());
            String value = json.getString(key);
            BCoreLog.d((String)("getData success: " + key + " = " + value));
            String string = value;
            return string;
        }
        catch (Exception e) {
            BCoreLog.e((String)("getData exception: " + e.getMessage()));
            e.printStackTrace();
            return null;
        }
    }

    public void getAPPStoreReview(Map<String, Object> gradeMap) {
        try {
            final Activity activity = ToolsModule.getInstance().getActivity();
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    String appPkg = activity.getPackageName();
                    String url = "http://play.google.com/store/apps/details?id=" + appPkg;
                    BCoreLog.d((String)("\u8c37\u6b4c\u8bc4\u5206\u8df3\u8f6c\u7684 url :" + url));
                    activity.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
                }
            });
        }
        catch (Exception error) {
            error.printStackTrace();
            BCoreLog.d((String)("\u8c37\u6b4c\u8bc4\u5206\u8df3\u8f6c\u7684 : " + error.getMessage()));
        }
    }

    public void getStoreReview(Map<String, Object> gradeMap) {
        com.youzu.android.framework.json.JSONObject jsonError = new com.youzu.android.framework.json.JSONObject();
        jsonError.put("code", (Object)BCoreCode.TOOLS_IPINFO_FAILURE);
        try {
            final Activity mAct = ToolsModule.getInstance().getActivity();
            if (this.hasCreateMethod()) {
                final ReviewManager manager = ReviewManagerFactory.create((Context)mAct);
                Task request = manager.requestReviewFlow();
                request.addOnCompleteListener((OnCompleteListener)new OnCompleteListener<ReviewInfo>(){

                    public void onComplete(@NonNull Task<ReviewInfo> task) {
                        com.youzu.android.framework.json.JSONObject jsonFailure = new com.youzu.android.framework.json.JSONObject();
                        jsonFailure.put("code", (Object)BCoreCode.TOOLS_IPINFO_FAILURE);
                        if (task.isSuccessful()) {
                            ReviewInfo reviewInfo = (ReviewInfo)task.getResult();
                            Task flow = manager.launchReviewFlow(mAct, reviewInfo);
                            flow.addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

                                public void onComplete(@NonNull Task<Void> task) {
                                    BCoreLog.d((String)"app\u5185\u5e94\u7528\u8c37\u6b4c\u8bc4\u4ef7\u5f39\u7a97\u5173\u95ed");
                                    com.youzu.android.framework.json.JSONObject json = new com.youzu.android.framework.json.JSONObject();
                                    json.put("code", (Object)1);
                                    json.put("msg", (Object)"app\u5185\u5e94\u7528\u8c37\u6b4c\u8bc4\u4ef7\u5f39\u7a97\u5173\u95ed");
                                    ToolsModule.getInstance().getModuleListener().onModule("tools", "getStoreReview", json.toJSONString());
                                }
                            });
                        } else {
                            BCoreLog.d((String)"app\u5185\u5e94\u7528\u8c37\u6b4c\u8bc4\u5206\u5931\u8d25,\u8c37\u6b4c\u5546\u5e97\u8fde\u63a5\u5931\u8d25");
                            jsonFailure.put("msg", (Object)"aapp\u5185\u5e94\u7528\u8c37\u6b4c\u8bc4\u5206\u5931\u8d25,\u8c37\u6b4c\u5546\u5e97\u8fde\u63a5\u5931\u8d25");
                            ToolsModule.getInstance().getModuleListener().onModule("tools", "getStoreReview", jsonFailure.toJSONString());
                        }
                    }
                });
            } else {
                jsonError.put("msg", (Object)"app\u5185\u5e94\u7528\u8c37\u6b4c\u8bc4\u5206\u5931\u8d25,\u672a\u68c0\u6d4b\u5230\u6240\u9700\u8d44\u6e90");
                ToolsModule.getInstance().getModuleListener().onModule("tools", "getStoreReview", jsonError.toJSONString());
            }
        }
        catch (Exception error) {
            error.printStackTrace();
            BCoreLog.d((String)("app\u5185\u5e94\u7528\u8c37\u6b4c\u8bc4\u5206\u5f02\u5e38 : " + error.getMessage()));
            jsonError.put("msg", (Object)"app\u5185\u5e94\u7528\u8c37\u6b4c\u8bc4\u5206\u5f02\u5e38");
            ToolsModule.getInstance().getModuleListener().onModule("tools", "getStoreReview", jsonError.toJSONString());
        }
    }

    private boolean hasCreateMethod() {
        try {
            Class<?> clazz = Class.forName("com.google.android.play.core.review.ReviewManagerFactory");
            if (clazz == null) {
                return false;
            }
            Method method = clazz.getMethod("create", Context.class);
            return method != null;
        }
        catch (ClassNotFoundException e) {
            BCoreLog.d((String)"hasCreateMethod,\u6ca1\u627e\u5230\u8fd9\u4e2a\u7c7b");
        }
        catch (NoSuchMethodException e) {
            BCoreLog.d((String)"hasCreateMethod,\u6ca1\u627e\u5230\u8fd9\u4e2a\u65b9\u6cd5");
        }
        return false;
    }

    public void openSystemSetting(Map<String, Object> gradeMap) {
        Activity activity = ToolsModule.getInstance().getActivity();
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)activity.getPackageName(), null);
        intent.setData(uri);
        try {
            activity.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getCpsId(Map<String, Object> params) {
        block50: {
            if (!TextUtils.isEmpty((CharSequence)mChannelId) && !"0".equals(mChannelId)) {
                BCoreLog.d((String)("META-INF getCpsId = " + mChannelId));
                return mChannelId;
            }
            String prefix = "META-INF/cps_";
            Activity activity = ToolsModule.getInstance().getActivity();
            if (activity == null) break block50;
            ApplicationInfo info = activity.getApplicationInfo();
            ZipFile file = null;
            try {
                file = new ZipFile(info.sourceDir);
                Enumeration<? extends ZipEntry> ele = file.entries();
                while (ele.hasMoreElements()) {
                    ZipEntry entry = ele.nextElement();
                    String fileName = entry.getName();
                    if (!fileName.contains(prefix) || TextUtils.isEmpty((CharSequence)(mChannelId = fileName.replace(prefix, ""))) || "0".equals(mChannelId)) continue;
                    BCoreLog.d((String)("META-INF getCpsId = " + mChannelId));
                    String string = mChannelId;
                    return string;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                block52: {
                    block51: {
                        if (file == null) break block51;
                        file.close();
                    }
                    try {
                        if (file != null) {
                            file.close();
                        }
                        break block52;
                    }
                    catch (IOException iOException) {}
                    break block52;
                    catch (Exception exception) {
                        try {
                            if (file != null) {
                                file.close();
                            }
                        }
                        catch (IOException iOException) {}
                        catch (Throwable throwable) {
                            try {
                                if (file != null) {
                                    file.close();
                                }
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                    }
                }
            }
        }
        mChannelId = "0";
        BCoreLog.d((String)("META-INF getCpsId = " + mChannelId));
        return mChannelId;
    }

    static {
        mChannelId = "";
    }

    private static class InstanceImpl {
        private static final ToolsHandler mInstance = new ToolsHandler();

        private InstanceImpl() {
        }
    }
}

