//
//  SSFArchive.h
//  SuperSDKFoundation
//
//  Created by shijl on 2022/4/22.
//  Copyright © 2022 youzu. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/// 归档文件
@interface SSFArchive : NSObject

/// 保存key-value至归档文件中
/// @param keyString 字典的key
/// @param valueString 字典的value
+ (BOOL)saveDataWithKeyString:(NSString *)keyString valueString:(NSString *)valueString;

/// 获取归档文件中的指定key的value
/// @param keyString 待查的key
+ (NSString *)getDataWithKeyString:(NSString *)keyString;

@end

NS_ASSUME_NONNULL_END
