//
//  SSFConfig.h
//  SuperSDKFoundation
//
//  Created by shijl on 2023/3/28.
//  Copyright © 2023 youzu. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

// 域名类型
typedef NS_ENUM (NSInteger, SSFDomainType) {
    SSFDomainDomestic,          // 国内域名
    SSFDomainForeign,     // 北美、台湾、欧洲
    SSFDomainForeignTW,   // 台湾、北美、欧洲
    SSFDomainTest         // 测试域名
};

// 游戏类型
typedef NS_ENUM(NSInteger, SSFGameType) {
    SSFGameOnline,        // 网游
    SSFGameSingleWeakNet, // 弱联网单机
    SSFGameSingleNonNet   // 纯单机游戏
};

// 单例对象
#define SSFConfigModuleObj ((SSFConfig*) [SSFConfig sharedInstance])

@interface SSFConfig : NSObject

@property (nonatomic, readonly, strong) NSDictionary *configData;   // 配置

@property (nonatomic, readonly, strong) NSDictionary *moduleMaps;   // 模块映射

@property (nonatomic, readonly, assign) SSFDomainType domainType;   // 域名类型

@property (nonatomic, readonly, assign) SSFGameType gameType;       // 游戏类型

+ (SSFConfig *)sharedInstance;

// 获取配置参数
+ (NSString *)getValue:(NSDictionary *)parameters;

@end

NS_ASSUME_NONNULL_END
