//
//  SSFDefine.h
//  SuperSDKFoundation
//
//  Created by shijl on 2022/4/22.
//  Copyright © 2022 youzu. All rights reserved.
//

#ifndef SSFDefine_h
#define SSFDefine_h
#import <SuperSDKFoundation/SSFLog.h>
#define SuperSDKFoundationTag  "SuperSDKFoundationTag"
// 获取字符串
#define SSFReplaceNil(Value,newValue) ((Value==nil||[Value isEqual:[NSNull null]])?newValue:Value)
#define SSFReplaceEmptyValue(Value,newValue) ((Value==nil||[Value isEqual:@""]||[Value isEqual:[NSNull null]])?newValue:Value)

// 字符串判空
#define SSFEmptyValue(string) ((string==nil||[string isEqual:@""]||[string isEqual:[NSNull null]])?YES:NO)

// 字符串判空和0
#define SSFEmptyAndZeroValue(string) ((string==nil||[string isEqual:@""]||[string isEqual:@"0"]||[string isEqual:[NSNull null]])?YES:NO)

// 字符串去除换行
#define SSFRemoveLineFeed(string) [[string stringByReplacingOccurrencesOfString:@"\n" withString:@""]stringByReplacingOccurrencesOfString:@"\r" withString:@""]

// 主线程运行
#define ssf_dispatch_async_main(block) [NSThread currentThread]==[NSThread mainThread]?block():dispatch_async(dispatch_get_main_queue(),block);

// 捕捉异常
#define ssf_catch_exception_start @try {

#define ssf_catch_exception_end }@catch (NSException *exception) {\
NSString *log = [NSString  stringWithFormat:@"%s,捕捉到异常\n*** Terminating app due to uncaught exception '%@',reson: %@,\n*** First throw call stack:\n %@", __PRETTY_FUNCTION__,exception.name,exception.reason,exception.callStackSymbols];\
SSF_LOG_TAG_INFO(SuperSDKFoundationTag,@"%@", log);}

#endif /* SSFDefine_h */
