//
//  SSFDevice.h
//  SuperSDKFoundation
//
//  Created by shijl on 2022/4/22.
//  Copyright © 2022 youzu. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

/// 设备信息
@interface SSFDevice : NSObject

#pragma mark - app名称
+ (NSString *)appName;

#pragma mark - app包名
+ (NSString *)appPacketName;

#pragma mark - app渠道
+ (NSString *)appUtm;

#pragma mark - app版本
+ (NSString *)appVer;

#pragma mark - 电池电量
+ (float)batteryLevel;

#pragma mark - 启动时间
+ (NSTimeInterval)boot;

#pragma mark - 手机屏幕亮度
+ (CGFloat)brightNess;

#pragma mark - 所属国家
+ (NSString *)country;

#pragma mark - 闪存剩余空间
+ (long long)availableMemorySize;

#pragma mark - IDFA
+ (NSString *)idfa;

#pragma mark - IDFV
+ (NSString *)idfv;

#pragma mark - VPN
+ (BOOL)isVPN;

#pragma mark - 系统语言
+ (NSString *)languages;

#pragma mark - 逻辑分辨率宽
+ (CGFloat)width;

#pragma mark - 逻辑分辨率高
+ (CGFloat)height;

#pragma mark - 逻辑分辨率比例
+ (CGFloat)scaledDensity;

#pragma mark - 手机内存
+ (unsigned long long)memorySize;

#pragma mark - 移动信号国家码
+ (NSString *)mcc;

#pragma mark - 移动网络号码
+ (NSString *)mnc;

#pragma mark - 手机设备型号代码
+ (NSString *)machine;

#pragma mark - 设备启动时间:TODO
+ (NSTimeInterval)bootTime;

#pragma mark - 设备启动时产生的UUID
+ (NSString *)bootUUID;

#pragma mark - CPU 核心数
+ (size_t)cpuCount;

#pragma mark - CPU架构
+ (cpu_type_t)cpuType;

#pragma mark - 判断代码是否正在被调试
+ (BOOL)isDebuggerRunning;

#pragma mark - 设备名称
+ (NSString *)name;

#pragma mark - app安装时间
+ (NSTimeInterval)appInstallTime;

#pragma mark - 获取网络类型
+ (NSString *)netWorkType;

#pragma mark - 手机系统名称
+ (NSString *)systemName;

#pragma mark - 手机系统版本
+ (NSString *)systemVersion;

#pragma mark - 高危目录列表(越狱采集)
// 检测到设备中存在TouchSprint的脚本目录
// /var/mobile/Media/TouchSprite/lua/
+ (BOOL)isExistRiskDir;

#pragma mark - 越狱文件是否存在
// 检测越狱文件是否存在来判断是否越狱
+ (BOOL)isExistJailBreakJudgmentBasisFiles;

#pragma mark - 采集信息时系统时间戳
// 每次采集信息时的系统时间戳
+ (NSTimeInterval)collectStartTime;

#pragma mark - 设备根目录磁盘总大小
+ (long long)totalDiskSize;

#pragma mark - 设备根目录磁盘使用大小
// 磁盘已经使用大小
+ (long long)usedDiskSize;

#pragma mark - 是否开启允许广告追踪
+ (BOOL)isOpenAttAuthorized;

#pragma mark - 电池充电状态
+ (NSInteger)batteryState;

#pragma mark - 用户设备类型
+ (NSString *)model;

#pragma mark - iCloud令牌
+ (NSString *)iCloudToken;

#pragma mark - DNS信息
+ (NSArray *)dns;

#pragma mark - SSID信息
+ (NSString *)ssid;

#pragma mark - BSSID信息
+ (NSString *)bssid;

#pragma mark - 内核版本
+ (NSString *)systemInfoVersion;

#pragma mark - 操作系统版本
+ (NSString *)operatingSystemVersion;

#pragma mark - environment
+ (NSDictionary *)processInfoEnvironment;

#pragma mark - 获取运营商的函数
+ (NSString *)addressInfoWithCarrierName;

#pragma mark - 判断网络环境的函数
+ (NSString *)addressInfoWithCurrentRadioAccessTechnology;

#pragma mark - 获取设备机型的函数
+ (NSString *)addressInfoWithSysctlbyname;

#pragma mark - 获取idfv的函数
+ (NSString *)addressInfoWithIdentifierForVendor;

#pragma mark - 获取地理位置的函数
+ (NSString *)addressInfoWithLocation;

#pragma mark - 获取地理位置的代理函数
+ (NSString *)addressInfoWithLocationDelegate;

#pragma mark - 获取设备模型的函数
+ (NSString *)addressInfoWithLocalizedModel;

#pragma mark - 获取国家代码(mcc)的函数
+ (NSString *)addressInfoWithMcc;

#pragma mark - 获取设备国家地区代码(mnc)的函数
+ (NSString *)addressInfoWithMnc;

#pragma mark - 获取设备类型的函数
+ (NSString *)addressInfoWithModel;

#pragma mark - 获取设备名称的函数
+ (NSString *)addressInfoWithName;

#pragma mark - 获取系统版本的函数
+ (NSString *)addressInfoWithSystemVersion;

#pragma mark - 游族Id
+ (NSString *)youzuId;

#pragma mark - 数美Id
+ (NSString *)shuMeiId;

#pragma mark - 获取设备指纹ID
+ (NSString *)getFingerprintId;

#pragma mark - 获取临时设备ID
+ (NSString *)getClientId;

#pragma mark - GPU名称
+ (NSString *)gpuName;

#pragma mark - GPU类型
+ (NSString *)gpuType;

#pragma mark - openGL版本
+ (NSString *)openGlVersion;

#pragma mark - 屏幕物理尺寸 - 宽
+ (float)physicalWidth;

#pragma mark - 屏幕物理尺寸 - 高
+ (float)physicalHeight;

#pragma mark - ASTC支持
+ (BOOL)astcSupport;

#pragma mark - 是否是模拟器
+ (BOOL)isSimulator;

#pragma mark - 模拟器信息
+ (NSString *)simulatorInfo;

#pragma mark - 时间相关
+ (NSString *)timestampInt10;   // 1650617965
+ (NSString *)timestampInt13;   // 1650617965123
+ (NSString *)timestampFloat10; // 1650617965.123456
+ (NSString *)formatTimestamp1; // yyyy-MM-dd hh-mm-ss
+ (NSString *)formatTimestamp2; // yyyy-MM-dd HH:mm:ss
+ (NSString *)formatTimestamp3; // yyyy-MM-dd HH-mm-ss
+ (NSString *)formatTimestamp4; // yyyy-MM-dd hh:mm:ss

#pragma mark - 获取网络运营商编码
+ (NSString *)getCarrierCode;

#pragma mark - 获取网络运营商
+ (NSString *)getCarrierInfo;

@end

NS_ASSUME_NONNULL_END
