//
//  SSFDomain.h
//  SuperSDKFoundation
//
//  Created by shijl on 2023/1/10.
//  Copyright © 2023 youzu. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/**
 飞书文档地址：https://youzu.feishu.cn/docx/N5J1dxfJ7oJseexNsyZcdQWan3c?from=from_copylink
 */

static NSString *const kServerModuleKey = @"moduleKey";  // 所需域名的模块名称
static NSString *const kServerFeatureKey = @"serverKey"; // 所需域名的功能名称

@interface SSFDomain : NSObject

// 读取配置文件是否成功
+ (BOOL)readServerConfigSuccess;

// 获取域名网址配置参数
+ (NSString *)getServerValue:(NSDictionary *)parameters;

@end

NS_ASSUME_NONNULL_END
