//
//  SSFKeychain.h
//  SuperSDKFoundation
//
//  Created by shijl on 2022/4/22.
//  Copyright © 2022 youzu. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/// 钥匙串存储
@interface SSFKeychain : NSObject

/// 钥匙串初始化
/// @param accessGroup 钥匙串组
- (instancetype)initWithAccessGroup:(NSString *)accessGroup;

/// 添加密码
/// @param service 服务
/// @param account 账号
/// @param password 密码
- (BOOL)addPasswordWithService:(NSString *)service
                       account:(NSString *)account
                      password:(NSString *)password;

/// 更新密码
/// @param service 服务
/// @param account 账号
/// @param password 密码
- (BOOL)updatePasswordWithService:(NSString *)service
                          account:(NSString *)account
                         password:(NSString *)password;

/// 删除密码
/// @param service 服务
/// @param account 账号
- (BOOL)deletePasswordWithService:(NSString *)service
                          account:(NSString *)account;

/// 读取密码
/// @param service 服务
/// @param account 账号
- (NSString *)readPasswordWithService:(NSString *)service
                              account:(NSString *)account;

@end

NS_ASSUME_NONNULL_END
