//
//  SSFLog.h
//  SuperSDKFoundation
//
//  Created by shijl on 2022/5/20.
//  Copyright © 2022 youzu. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

// 强制打印信息
#define SSF_LOG_FORCE(fmt,...) SSF_LOG_BASIC("FORCE", SSF_BCORELOGLEVEL_FORCE, fmt, ##__VA_ARGS__)

// 错误信息
#define SSF_LOG_ERROR(fmt,...) SSF_LOG_BASIC("ERROR", SSF_BCORELOGLEVEL_ERROR, fmt, ##__VA_ARGS__)

// 警告信息
#define SSF_LOG_WARN(fmt,...)  SSF_LOG_BASIC("WARN", SSF_BCORELOGLEVEL_WARN, fmt, ##__VA_ARGS__)

// 普通打印信息
#define SSF_LOG_INFO(fmt,...)  SSF_LOG_BASIC("INFO", SSF_BCORELOGLEVEL_INFO, fmt, ##__VA_ARGS__)

// 调试信息
#define SSF_LOG_DEBUG(fmt,...) SSF_LOG_BASIC("DEBUG", SSF_BCORELOGLEVEL_DEBUG, fmt, ##__VA_ARGS__)

// Tag打印
#define SSF_LOG_TAG_INFO(TAG,fmt,...) SSF_LOG_BASIC(TAG, SSF_BCORELOGLEVEL_INFO, fmt, ##__VA_ARGS__)

// 日志打印
#define SSF_LOG_BASIC(note, logLevel, fmt, ...) [SSFLog printf:note level:logLevel file:__FILE__ line:__LINE__ func:__PRETTY_FUNCTION__ log:fmt, ##__VA_ARGS__]

// 日志等级
static const int SSF_BCORELOGLEVEL_FORCE = 1000;
static const int SSF_BCORELOGLEVEL_ERROR = 40;
static const int SSF_BCORELOGLEVEL_WARN  = 30; // 默认等级
static const int SSF_BCORELOGLEVEL_INFO  = 20;
static const int SSF_BCORELOGLEVEL_DEBUG = 10;

/// 日志
@interface SSFLog : NSObject

/// 日志是否开启
+ (BOOL)logEnabled;

/// 打开控制台日志
/// @param yesOrNo @(YES) or @(NO)
+ (void)openInfoLog:(NSNumber *)yesOrNo;

///  打印日志
/// @param note 等级描述
/// @param level 等级
/// @param file 文件描述
/// @param line 行描述
/// @param func 方法描述
/// @param fmt 额外参数
+ (void)printf:(const char*)note
         level:(int)level
          file:(const char*)file
          line:(int)line
          func:(const char*)func
           log:(NSString *)fmt,...;

@end

NS_ASSUME_NONNULL_END
