//
//  SSFNetwork.h
//  SuperSDKFoundation
//
//  Created by shijl on 2022/4/22.
//  Copyright © 2022 youzu. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/// 网络变化监听（备注：可配合networkAvailable方法）
extern NSString *kSSFChangedNotification;

typedef void(^SSF_Success)(id  obj,NSString *url);
typedef void(^SSF_Failture)(NSError * error,NSString *url);

typedef void(^SSF_OriSuccess)(NSHTTPURLResponse *response,id  obj,NSString *url);
typedef void(^SSF_OriFailture)(NSHTTPURLResponse *response,NSError * error,NSString *url);

/// 请求方式
typedef NS_ENUM(NSInteger, SSFRequestMethod) {
    SSFRequestMethodGET, // GET
    SSFRequestMethodPOST // POST
};

/// 网络管理类
@interface SSFNetwork : NSObject

/// 网络是否可用
+ (BOOL)networkAvailable;

/*********************************************************原始请求*******************************************************************/
/// 原始异步请求
/// @param request 请求对象
/// @param sessionDelegate 对象
/// @param success 成功回调
/// @param failure 失败回调
+ (void)asynOriRequest:(NSURLRequest *)request
       sessionDelegate:(id<NSURLSessionDelegate>)sessionDelegate
               success:(SSF_OriSuccess)success
               failure:(SSF_OriFailture)failure;

/// 原始同步请求
/// @param request 请求对象
/// @param sessionDelegate 对象
/// @param success 成功回调
/// @param failure 失败回调
+ (void)synOriRequest:(NSURLRequest *)request
      sessionDelegate:(id<NSURLSessionDelegate>)sessionDelegate
              success:(SSF_OriSuccess)success
              failure:(SSF_OriFailture)failure;



/// 原始异步请求
/// @param urlPath 请求对象
/// @param headerDic 请求头部
/// @param params 请求参数
/// @param sessionDelegate 对象
/// @param success 成功回调
/// @param failure 失败回调
+ (void)asynOriRequest:(NSString *)urlPath
               headers:(id)headerDic
                params:(id)params
                method:(SSFRequestMethod)method
       sessionDelegate:(id<NSURLSessionDelegate>)sessionDelegate
               success:(SSF_OriSuccess)success
               failure:(SSF_OriFailture)failure;

/// 原始同步请求
/// @param urlPath 请求对象
/// @param headerDic 请求头部
/// @param params 请求参数
/// @param sessionDelegate 对象
/// @param success 成功回调
/// @param failure 失败回调
+ (void)synOriRequest:(NSString *)urlPath
              headers:(id)headerDic
               params:(id)params
               method:(SSFRequestMethod)method
      sessionDelegate:(id<NSURLSessionDelegate>)sessionDelegate
              success:(SSF_OriSuccess)success
              failure:(SSF_OriFailture)failure;


/// 原始同步多url请求
/// @param urlPaths url数组
/// @param headerDic 请求头
/// @param params 请求参数
/// @param sessionDelegate 对象
/// @param method 请求方法
/// @param success 成功回调
/// @param failure 失败回调
+ (void)synOriRequestMultiUrl:(NSArray *)urlPaths
                      headers:(id)headerDic
                       params:(id)params
              sessionDelegate:(id<NSURLSessionDelegate>)sessionDelegate
                       method:(SSFRequestMethod)method
                      success:(SSF_OriSuccess)success
                      failure:(SSF_OriFailture)failure;


/// 原始异步多url请求
/// @param urlPaths url数组
/// @param headerDic 请求头
/// @param params 请求参数
/// @param sessionDelegate 对象
/// @param method 请求方法
/// @param success 成功回调
/// @param failure 失败回调
+ (void)asynOriRequestMultiUrl:(NSArray *)urlPaths
                       headers:(id)headerDic
                        params:(id)params
               sessionDelegate:(id<NSURLSessionDelegate>)sessionDelegate
                        method:(SSFRequestMethod)method
                       success:(SSF_OriSuccess)success
                       failure:(SSF_OriFailture)failure;


/// 原始同步多url请求
/// @param request 请求对象
/// @param urlPaths url数组
/// @param sessionDelegate 对象
/// @param method 请求方法
/// @param success 成功回调
/// @param failure 失败回调
+ (void)synOriRequestMultiUrl:(NSURLRequest *)request
                     urlPaths:(NSArray *)urlPaths
              sessionDelegate:(id<NSURLSessionDelegate>)sessionDelegate
                       method:(SSFRequestMethod)method
                      success:(SSF_OriSuccess)success
                      failure:(SSF_OriFailture)failure;


/// 原始异步多url请求
/// @param request 请求对象
/// @param urlPaths url数组
/// @param sessionDelegate 对象
/// @param method 请求方法
/// @param success 成功回调
/// @param failure 失败回调
+ (void)asynOriRequestMultiUrl:(NSURLRequest *)request
                      urlPaths:(NSArray *)urlPaths
               sessionDelegate:(id<NSURLSessionDelegate>)sessionDelegate
                        method:(SSFRequestMethod)method
                       success:(SSF_OriSuccess)success
                       failure:(SSF_OriFailture)failure;


/****************************常规请求相关**********************************************/

/// 异步请求
/// @param request 请求对象
/// @param sessionDelegate 对象
/// @param success 成功回调
/// @param failure 失败回调
+ (void)asynRequest:(NSURLRequest *)request
    sessionDelegate:(id<NSURLSessionDelegate>)sessionDelegate
            success:(SSF_Success)success
            failure:(SSF_Failture)failure;


/// 同步请求
/// @param request 请求对象
/// @param sessionDelegate 对象
/// @param success 成功回调
/// @param failure 失败回调
+ (void)synRequest:(NSURLRequest *)request
   sessionDelegate:(id<NSURLSessionDelegate>)sessionDelegate
           success:(SSF_Success)success
           failure:(SSF_Failture)failure;


/// 异步请求
/// @param urlPath 请求对象
/// @param headerDic 请求头部
/// @param params 请求参数
/// @param sessionDelegate 对象
/// @param success 成功回调
/// @param failure 失败回调
+ (void)asynRequest:(NSString *)urlPath
            headers:(id)headerDic
             params:(id)params
             method:(SSFRequestMethod)method
    sessionDelegate:(id<NSURLSessionDelegate>)sessionDelegate
            success:(SSF_Success)success
            failure:(SSF_Failture)failure;


/// 同步请求
/// @param urlPath 请求对象
/// @param headerDic 请求头部
/// @param params 请求参数
/// @param sessionDelegate 对象
/// @param success 成功回调
/// @param failure 失败回调
+ (void)synRequest:(NSString *)urlPath
           headers:(id)headerDic
            params:(id)params
            method:(SSFRequestMethod)method
   sessionDelegate:(id<NSURLSessionDelegate>)sessionDelegate
           success:(SSF_Success)success
           failure:(SSF_Failture)failure;



/// 异步多url请求
/// @param urlPaths url数组
/// @param headerDic 请求头
/// @param params 请求参数
/// @param sessionDelegate 请求参数
/// @param method 请求方法
/// @param success 成功回调
/// @param failure 失败回调
+ (void)asynRequestMultiUrl:(NSArray *)urlPaths
                    headers:(id)headerDic
                     params:(id)params
            sessionDelegate:(id<NSURLSessionDelegate>)sessionDelegate
                     method:(SSFRequestMethod)method
                    success:(SSF_Success)success
                    failure:(SSF_Failture)failure;

/// 同步多url请求
/// @param urlPaths url数组
/// @param headerDic 请求头
/// @param params 请求参数
/// @param sessionDelegate 请求参数
/// @param method 请求方法
/// @param success 成功回调
/// @param failure 失败回调
+ (void)synRequestMultiUrl:(NSArray *)urlPaths
                   headers:(id)headerDic
                    params:(id)params
           sessionDelegate:(id<NSURLSessionDelegate>)sessionDelegate
                    method:(SSFRequestMethod)method
                   success:(SSF_Success)success
                   failure:(SSF_Failture)failure;




/// 同步多url请求
/// @param request 请求对象
/// @param urlPaths url数组
/// @param sessionDelegate 对象
/// @param method 请求方法
/// @param success 成功回调
/// @param failure 失败回调
+ (void)synRequestMultiUrl:(NSURLRequest *)request
                  urlPaths:(NSArray *)urlPaths
           sessionDelegate:(id<NSURLSessionDelegate>)sessionDelegate
                    method:(SSFRequestMethod)method
                   success:(SSF_Success)success
                   failure:(SSF_Failture)failure;


/// 异步多url请求
/// @param request 请求对象
/// @param urlPaths url数组
/// @param sessionDelegate 对象
/// @param method 请求方法
/// @param success 成功回调
/// @param failure 失败回调
+ (void)asynRequestMultiUrl:(NSURLRequest *)request
                   urlPaths:(NSArray *)urlPaths
            sessionDelegate:(id<NSURLSessionDelegate>)sessionDelegate
                     method:(SSFRequestMethod)method
                    success:(SSF_Success)success
                    failure:(SSF_Failture)failure;




/*************************************************原版httpRequest请求********************************************************************/

/// 异步多url请求
/// @param urlPaths url数组
/// @param headerDic 请求头
/// @param params 请求参数
/// @param method 请求方法
/// @param success 成功回调
/// @param failure 失败回调
+ (void)asynRequestMultiUrl:(NSArray *)urlPaths
                    headers:(id)headerDic
                     params:(id)params
                     method:(SSFRequestMethod)method
                    success:(void(^)(id obj,NSString *url))success
                    failure:(void(^)(NSError *error))failure;

/// 异步多url的post请求
/// @param urlPaths url数组
/// @param headerDic 请求头
/// @param bodyData 请求体
/// @param success 成功回调
/// @param failure 失败回调
+ (void)asynPostRequestMultiUrl:(NSArray *)urlPaths
                        headers:(NSDictionary *)headerDic
                       bodyData:(NSData *)bodyData
                        success:(void(^)(id obj,NSString *url))success
                        failure:(void(^)(NSError *error))failure;
@end

NS_ASSUME_NONNULL_END
