//
//  SSFQueue.h
//  SuperSDKFoundation
//
//  Created by shijl on 2022/5/9.
//  Copyright © 2022 youzu. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef void(^SSFQueueBlock)(void);

NS_ASSUME_NONNULL_BEGIN

@interface SSFQueue : NSObject

/// 添加到异步串型读队列
/// @param block 执行的代码块
+ (void)addToAsyncSerialReadQueueWithBlock:(SSFQueueBlock)block;

/// 添加到异步串型写队列
/// @param block 执行的代码块
+ (void)addToAsyncSerialWriteQueueWithBlock:(SSFQueueBlock)block;

@end

NS_ASSUME_NONNULL_END
