//
//  SSFTools.h
//  SuperSDKFoundation
//
//  Created by shijl on 2022/4/22.
//  Copyright © 2022 youzu. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-function"

// URL编码
static NSString *ssfUrlUsingEncoding(NSString *string, NSStringEncoding encoding) {
    if(![string isMemberOfClass:[NSString class]]){
        string = [NSString stringWithFormat:@"%@",string];
    }
    
    return (NSString *)CFBridgingRelease(CFURLCreateStringByAddingPercentEscapes(NULL,
                                                                                 (CFStringRef)string,
                                                                                 NULL,
                                                                                 (CFStringRef)@"!*'\"();:@&=+$,/?%#[]% ",
                                                                                 CFStringConvertNSStringEncodingToEncoding(encoding)));
}

// 连接参数
static NSString *ssfAssembleParamWithUrlEncoding(NSMutableDictionary *parameters)
{
    if(!parameters||parameters.count==0)
        return nil;
    // 排序拼接参数，得到verify的值
    NSString *verify = @"";
    NSArray *resultArray = [[parameters allKeys] sortedArrayUsingSelector:@selector(compare:)];
    unsigned long count = parameters.count;
    int i = 0;
    for (i = 0; i < count; i++) {
        id key = [resultArray objectAtIndex:i];
        verify = [verify stringByAppendingFormat:@"%@=%@&", key,ssfUrlUsingEncoding([parameters valueForKey:key], NSUTF8StringEncoding)];
    }
    
    verify = [verify substringToIndex:verify.length-1];
    
    return verify;
}

// 连接参数
static NSString *ssfAssembleParam(NSMutableDictionary *parameters)
{
    if(!parameters||parameters.count==0)
        return nil;
    // 排序拼接参数，得到verify的值
    NSString *verify = @"";
    NSArray *resultArray = [[parameters allKeys] sortedArrayUsingSelector:@selector(compare:)];
    unsigned long count = parameters.count;
    int i = 0;
    for (i = 0; i < count; i++) {
        id key = [resultArray objectAtIndex:i];
        verify = [verify stringByAppendingFormat:@"%@=%@&", key,[parameters valueForKey:key]];
    }
    
    verify = [verify substringToIndex:verify.length-1];
    
    return verify;
}

#pragma clang diagnostic pop

/// 常用工具
@interface SSFTools : NSObject

/**
 *  Description     字符串base64加密
 *
 *  @param string   待加密字符串
 */
+ (NSString *)base64EncodedString:(NSString *)string options:(NSDataBase64EncodingOptions)options;

/**
 *  Description     二进制base64加密
 *
 *  @param data     待加密二进制
 */
+ (NSString *)base64EncodedStringFromData:(NSData *)data options:(NSDataBase64EncodingOptions)options;

/**
 *  Description             base64字符串解密
 *
 *  @param base64String     待解密base64字符串
 */
+ (NSString *)base64DecodingString:(NSString *)base64String options:(NSDataBase64DecodingOptions)options;

/**
 *  Description         base64二进制解密
 *
 *  @param base64Data   待解密二进制
 */
+ (NSString *)base64DecodingStringFromData:(NSData *)base64Data options:(NSDataBase64DecodingOptions)options;

/**
 *  Description         MD5
 *
 *  @param string   待MD5字符串
 */
+ (NSString *)md5String:(NSString *)string;

/// json对象转字符串
/// @param jsonObj json对象
+ (NSString *)jsonObjToString:(id)jsonObj;

/// json对象转字符串
/// @param jsonObj json对象
/// @param error  错误信息
+ (NSString *)jsonObjToString:(id)jsonObj error:(NSError **)error;

/// json字符串转json对象
/// @param jsonString json字符串
+ (id)jsonStrToObj:(NSString *)jsonString;


/// json字符串转json对象
/// @param jsonString json字符串
/// @param error  错误信息
+ (id)jsonStrToObj:(NSString *)jsonString error:(NSError **)error;

/// json字符串转json对象
/// @param jsonData NSData类型
/// @param error  错误信息
+ (id)jsonDataToObj:(NSData *)jsonData error:(NSError **)error;

///  应用根视图
+ (UIViewController *)appRootViewController;

/// 应用顶部视图
+ (UIViewController *)appTopViewController:(UIViewController *)rootViewController;

/// 根视图控制器
+ (UIViewController *)rootViewController;

/// 顶部控制器
+ (UIViewController *)topViewController;

/// 当前的窗体（优先delegate.window，再keyWindow）
+ (UIWindow *)currentWindow;

@end

NS_ASSUME_NONNULL_END
